//
// (c) 2020 wesolutions GmbH
// All rights reserved.
//

import QtQuick 2.12

import wesual.Ui 1.0

import wesual.Ui.Private 1.0

import "private"

UiToolButtonBase {
    id : uiMenuButton

    property alias text     : toolButton.text
    property alias iconName : toolButton.iconName
    property alias iconSize : toolButton.iconSize

    readonly property bool pressed :
        toolButton.pressed || popupAnchor.popupVisible

    property list<UiMenuItem> __items

    default property alias items : uiMenuButton.__items

    function close() {
        popupAnchor.hide();
    }

    implicitWidth  : toolButton.implicitWidth
    implicitHeight : toolButton.implicitHeight

    UiToolButton {
        id : toolButton

        onClicked : {
            for (var i = 0; i < __items.length; ++i) {
                if (__items[i].update) {
                    __items[i].update();
                }
            }

            popupAnchor.show();
        }
        down      : popupAnchor.popupVisible
    }

    UiPopupAnchor {
        id : popupAnchor

        anchors {
            bottom       : parent.bottom
            bottomMargin : 1
            left         : parent.left
        }
        popupCreationPolicy : UiPopupAnchor.OnDemandCreation
        persistent          : false
        triggerItem         : toolButton
        autoLayout          : true

        popup : Rectangle {
            id : popup

            implicitWidth  : Math.max(content.implicitWidth + 2,
                                      toolButton.implicitWidth)
            implicitHeight : content.implicitHeight + 8
            opacity        : 0
            enabled        : false

            border {
                color : UiColors.getColor(UiColors.ControlGrey20)
                width : 1
            }

            states : State {
                name : "visible"
                when : popupAnchor.popupVisible

                PropertyChanges {
                    target  : popup
                    opacity : 1
                    enabled : true
                }
            }

            UiBorder {
                borderWidth  : 1
                color        : UiColors.getColor(UiColors.ControlGrey20)
                anchors.fill : parent
                style        : UiBorder.Solid
                z            : 2
            }

            MouseArea {
                id : mouseArea

                readonly property Item itemUnderMouse : {
                    if (!containsMouse)
                        return null;

                    return content.childAt(mouseX, mouseY);
                }

                anchors.fill : content
                hoverEnabled : true

                onReleased   : {
                    if (itemUnderMouse && itemUnderMouse.enabled) {
                        itemUnderMouse.clicked();
                    }
                }
            }

            Column {
                id : content

                readonly property int preferredWidth : {
                    var w = 0;

                    for (var i = 0; i < repeater.count; ++i) {
                        w = Math.max(w, repeater.itemAt(i).implicitWidth);
                    }

                    return w;
                }

                x     : 1
                y     : 4
                width : popup.width - 2

                Repeater {
                    id : repeater

                    model    : uiMenuButton.items
                    delegate : UiMenuButtonDelegate {
                        menuItem   : modelData
                        menuButton : uiMenuButton
                        pressed    : mouseArea.itemUnderMouse === this &&
                                     mouseArea.containsPress
                        hovered    : mouseArea.itemUnderMouse === this
                        width      : content.preferredWidth
                    }
                }
            }
        }
    }
}

